#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
//#include "ctrl/BOLTReport.h"
#include "BOLTFrm.h"
#include "form/BOLTforms.h"
#include "report/brTrigger.h"
#include "wx/statline.h"
#include <wx/cmndata.h>
#include "wx/printdlg.h"
enum {
 ID_NEW=13120,
 ID_EDIT,
 ID_DELETE,
 ID_LIST
};

//IMPLEMENT_DYNAMIC_CLASS(brTrigger,wxPanel)
BEGIN_EVENT_TABLE(brTrigger,wxPanel)
EVT_BUTTON(ID_NEW,brTrigger::OnNew)
EVT_BUTTON(ID_EDIT,brTrigger::OnEdit)
EVT_BUTTON(ID_DELETE,brTrigger::OnDelete)
EVT_LISTBOX(ID_LIST,brTrigger::OnSelect)
EVT_LISTBOX_DCLICK(ID_LIST,brTrigger::OnEdit)
END_EVENT_TABLE()

brTrigger::brTrigger(wxWindow *parent,BOLTdb *db, RECORD_ID recordId):
 wxPanel(parent,-1)
{	 this->db=db;
	 this->recordId=recordId;
	SetFont(parent->GetFont());

SetBackgroundColour(parent->GetBackgroundColour());

wxBoxSizer *topSizer;
topSizer=new wxBoxSizer(wxVERTICAL);
topSizer->Add(new wxStaticText(this,-1,"Triggers"),0,wxALIGN_CENTER|wxALL,2);
topSizer->Add(new wxStaticLine(this,-1),0,wxEXPAND);
wxBoxSizer *bSizer;

topSizer->Add(new wxListBox(this,ID_LIST),1,wxEXPAND|wxALL,2);

bSizer=new wxBoxSizer(wxHORIZONTAL);
bSizer->Add(new wxButton(this,ID_NEW,"New"),0,wxALIGN_CENTER|wxALL,2);
bSizer->Add(new wxButton(this,ID_EDIT,"Edit"),0,wxALIGN_CENTER|wxALL,2);
bSizer->Add(new wxButton(this,ID_DELETE,"Delete"),0,wxALIGN_CENTER|wxALL,2);
topSizer->Add(bSizer,0,wxALIGN_CENTER|wxALL,2);
//SetAutoLayout(TRUE);
SetSizerAndFit(topSizer);
FillList();

};

void brTrigger::FillList()
{
	QRY_ID qry;
	void *row;
	char *tmp;
	wxString tStr;
	wxListBox *list;

	list=(wxListBox *)this->FindWindow(ID_LIST);
	if (!list) { return; }
	int cSel;
	cSel=list->GetSelection();
	list->Clear(); aId.Empty();
	tStr.Printf("select id,concat(name,' x ',if (runAmount is null,1,runAmount),' --> ',if (outputStyle=0 or outputStyle is null,'Screen',if(outputStyle=1,concat('Print to ',if(printer is null,'Default',printer)),if(outputStyle=2,'Save','Send')))) from reportTriggers where reportId=%u order by id",recordId);
	if (qry=db->Query(tStr.c_str(),tStr.Length()))
	{
		while (row=db->FetchRow(qry))
		{
			tmp=db->FetchQueryResult(qry,row,0);
			tStr=db->FetchQueryResult(qry,row,1);
			list->Append(tStr);
			aId.Add(atoi(tmp));
		}
		db->FreeQuery(qry);
	}
	if (cSel>=list->Number())
		{ cSel=list->Number()-1; };
	if (cSel>-1)
		list->SetSelection(cSel,TRUE);
	OnSelect(wxCommandEvent(0,0));
}

void brTrigger::OnNew(wxCommandEvent & event)
{
	wxString tStr;
	RECORD_ID newId;

	newId=db->NewRecord("ReportTriggers");
	db->SetValue("ReportTriggers","reportId",newId,recordId);
	db->SetValue("ReportTriggers","name",newId,"'New Trigger'");
	brTriggerEditor *brTE;
	brTE=new brTriggerEditor(this,db,newId);
	brTE->Destroy();
	FillList();
};

void brTrigger::OnEdit(wxCommandEvent & event)
{
	wxListBox *list;
	list=(wxListBox *)this->FindWindow(ID_LIST);
	if (!list) { return; }
	int sel=list->GetSelection();

	brTriggerEditor *brTE;
	brTE=new brTriggerEditor(this,db,(RECORD_ID)aId[sel]);
	brTE->Destroy();
	FillList();
	list->SetSelection(sel);
};

void brTrigger::OnDelete(wxCommandEvent & event)
{
	wxListBox *list;
	wxString tStr;
	if (wxMessageBox("Are you sure you would like to delete this trigger ?","Confirm Delete",wxYES_NO,this)==wxNO)
		{ return; }
	list=(wxListBox *)this->FindWindow(ID_LIST);
	if (!list) { return; }
	int sel=list->GetSelection();
	if ((sel<0) || (!aId[sel])) { return; }

	tStr.Printf("delete from ReportTriggers where id=%u",
			aId[sel]);
	db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
	FillList();
};

void brTrigger::OnSelect(wxCommandEvent &event)
{
wxListBox *list;
int max,sel;
list=(wxListBox *)this->FindWindow(ID_LIST);
max=list->Number()-1;
sel=list->GetSelection();

this->FindWindow(ID_NEW)->Enable(TRUE);
this->FindWindow(ID_EDIT)->Enable((sel>=0)&&(sel<=max));
this->FindWindow(ID_DELETE)->Enable((sel>=0)&&(sel<=max));
}

enum { TE_TEXT=8800,
TE_CHOICE,
TE_TEXTONLY,
TE_PASV,
TE_AUTONUMBER,
TE_PRINTER,
TE_SERVER,
TE_PATH,
TE_USER,
TE_PASS,
TE_BROWSE
};

//IMPLEMENT_DYNAMIC_CLASS(brTriggerEditor,wxDialog)
BEGIN_EVENT_TABLE(brTriggerEditor,wxDialog)
EVT_BUTTON(TE_PATH,brTriggerEditor::OnBrowse)
EVT_TEXT(TE_TEXT,brTriggerEditor::OnText)
EVT_TEXT(TE_PATH,brTriggerEditor::OnText)
EVT_TEXT(TE_USER,brTriggerEditor::OnText)
EVT_TEXT(TE_PASS,brTriggerEditor::OnText)
EVT_TEXT(TE_SERVER,brTriggerEditor::OnText)
EVT_CHOICE(TE_CHOICE,brTriggerEditor::OnChoice)
EVT_BUTTON(TE_PRINTER,brTriggerEditor::OnPrinter)
EVT_BUTTON(TE_BROWSE,brTriggerEditor::OnBrowse)
EVT_CHECKBOX(TE_TEXTONLY,brTriggerEditor::OnTextOnly)
EVT_CHECKBOX(TE_PASV,brTriggerEditor::OnPassive)
//EVT_CHECKBOX(TE_AUTONUMBER,brTriggerEditor::OnAutoNumber)
END_EVENT_TABLE()

brTriggerEditor::brTriggerEditor(wxWindow *parent,BOLTdb *db,RECORD_ID recordId) :
wxDialog(parent,-1,"Trigger Editor",wxDefaultPosition)
{	 
	this->db=db;
	this->recordId=recordId;
	SetFont(parent->GetFont());

	bcChoice *cType;
	wxBoxSizer *topSizer;
	wxBoxSizer *hSizer;
		wxString choices[]={		wxString("Screen"),
		wxString("Printer"),
		wxString("My Computer"),
		wxString("Another Computer")};
		
	topSizer=new wxBoxSizer(wxVERTICAL);
	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(new wxStaticText(this,-1,"Trigger Name"),0,wxALL,7);
	hSizer->Add(new bcItem(this,TE_TEXT,"reportTriggers","name",db,recordId),0,wxALIGN_RIGHT,5);
	topSizer->Add(hSizer,0,wxEXPAND);

	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(new wxStaticText(this,-1,"Copies"),0,wxALL,7);
	hSizer->Add(new bcItem(this,TE_TEXT,"reportTriggers","runAmount",db,recordId),0,wxALL,5);
	hSizer->Add(new wxCheckBox(this,TE_TEXTONLY,"Text Only"),0,wxALIGN_RIGHT|wxALL,5);
	((wxCheckBox *)this->FindWindow(TE_TEXTONLY))->SetValue(db->GetValue("reportTriggers","textOnly",this->recordId)!=NULL);
	topSizer->Add(hSizer,0,wxEXPAND);

	topSizer->Add(cType=new bcChoice(this,TE_CHOICE,"Output to",4,choices,
		"reportTriggers","outputStyle",db,recordId),0,wxALIGN_TOP|wxALL,5);
	topSizer->Add(new wxStaticLine(this,-1),0,wxEXPAND);

	topSizer->Add(new wxButton(this,TE_PRINTER,"Print Setup"),0,wxALIGN_CENTER|wxALL,5);
/*Sizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(new wxStaticText(this,-1,"Printer"),0,wxALL,7);
	hSizer->Add(new wxChoice(this,TE_PRINTER),0,wxALL|5);
	topSizer->Add(hSizer,0,wxEXPAND);
*/
	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(new wxStaticText(this,-1,"File Path"),1,wxALL,7);
	hSizer->Add(new bcItem(this,TE_PATH,"reportTriggers","path",db,recordId),1,wxALL|5);
	hSizer->Add(new wxButton(this,TE_BROWSE,"&Browse"),1,wxALL|5);
//	hSizer->Add(new wxCheckBox(this,TE_AUTONUMBER,"Autonumber"),0,wxALIGN_RIGHT|wxALL,5);
	topSizer->Add(hSizer,0,wxEXPAND);

	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(new wxStaticText(this,-1,"Server"),1,wxALL,7);
	hSizer->Add(new bcItem(this,TE_SERVER,"reportTriggers","server",db,recordId),1,wxALL|5);
	wxCheckBox *wcb;
	wxString tPass;

	hSizer->Add(wcb=new wxCheckBox(this,TE_PASV,"Passive Mode"),1,wxALIGN_RIGHT|wxALL,5);
	tPass=db->GetValue("reportTriggers","passive",recordId);
	wcb->SetValue(!tPass.IsEmpty());	
	topSizer->Add(hSizer,0,wxEXPAND);

	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(new wxStaticText(this,-1,"Username"),1,wxALL,7);
	hSizer->Add(new bcItem(this,TE_USER,"reportTriggers","username",db,recordId),1,wxALL|5);
	hSizer->Add(1,1,1);
	topSizer->Add(hSizer,0,wxEXPAND);

	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(new wxStaticText(this,-1,"Password"),1,wxALL,7);
	hSizer->Add(new bcItem(this,TE_PASS,"reportTriggers","password",db,recordId),1,wxALL|5);
	hSizer->Add(1,1,1);
	topSizer->Add(hSizer,0,wxEXPAND);

	topSizer->Add(new wxButton(this,wxID_CANCEL,"&Done"),0,wxALIGN_CENTER|wxALL,5);

//	SetAutoLayout(TRUE);
	SetSizerAndFit(topSizer);
	topSizer->SetSizeHints( this );
	topSizer->Fit( this );
	Centre( wxBOTH );

this->FindWindow(TE_PASV)->Enable(cType->GetSelection()==3);
//this->FindWindow(TE_AUTONUMBER)->Enable(cType->GetSelection()==2);
this->FindWindow(TE_PRINTER)->Enable(cType->GetSelection()==1);
this->FindWindow(TE_SERVER)->Enable(cType->GetSelection()==3);
this->FindWindow(TE_PATH)->Enable(cType->GetSelection()>1);
this->FindWindow(TE_USER)->Enable(cType->GetSelection()==3);
this->FindWindow(TE_PASS)->Enable(cType->GetSelection()==3);
this->FindWindow(TE_BROWSE)->Enable(cType->GetSelection()==2);

	ShowModal();

};



void brTriggerEditor::OnText(wxCommandEvent &event)
{
	bcItem *item;
	item = (bcItem *)event.GetEventObject();
	if (item) { item->OnEdit();}
}

void brTriggerEditor::OnChoice(wxCommandEvent &event)
{
	bcChoice *cType;
	bcChoice::OnRadioBox(event);
	cType=(bcChoice *)event.GetEventObject();
this->FindWindow(TE_PASV)->Enable(cType->GetSelection()==3);
//this->FindWindow(TE_AUTONUMBER)->Enable(cType->GetSelection()==2);
this->FindWindow(TE_PRINTER)->Enable(cType->GetSelection()==1);
this->FindWindow(TE_SERVER)->Enable(cType->GetSelection()==3);
this->FindWindow(TE_PATH)->Enable(cType->GetSelection()>1);
this->FindWindow(TE_USER)->Enable(cType->GetSelection()==3);
this->FindWindow(TE_PASS)->Enable(cType->GetSelection()==3);
this->FindWindow(TE_BROWSE)->Enable(cType->GetSelection()==2);
}

void brTriggerEditor::OnTextOnly(wxCommandEvent &event)
{
	if (event.IsChecked())
	{ db->SetValue("reportTriggers","textOnly",this->recordId,"1"); }
	else 
	{ db->SetValue("reportTriggers","textOnly",this->recordId,"NULL"); }
}

void brTriggerEditor::OnPassive(wxCommandEvent &event)
{
	if (event.IsChecked())
	{ db->SetValue("reportTriggers","passive",this->recordId,"1"); }
	else 
	{ db->SetValue("reportTriggers","passive",this->recordId,"NULL"); }	
}

void brTriggerEditor::OnAutoNumber(wxCommandEvent &event)
{

}

void brTriggerEditor::OnPrinter(wxCommandEvent &event)
{
//wxPrintDialog *printWin;
//wxPrintDialogData printData;
wxPrintDialog *printWin;
//wxPageSetupDialogData printData;
//printData.EnableMargins(FALSE);
wxPrintData pData;

wxString printerName,tStr;
wxPrintDialogData *printData;
printData=new wxPrintDialogData();

pData=printData->GetPrintData();
printerName=db->GetValue("reportTriggers","printer",this->recordId);
pData.SetPrinterName(printerName);
pData.SetPaperId((wxPaperSize)db->GetIValue("reportTriggers","paperSize",recordId));
int poptions,pquality;
	poptions=db->GetIValue("reportTriggers","paperOptions",recordId);
	pData.SetOrientation(poptions);
	poptions=db->GetIValue("reportTriggers","printColor",recordId);
	pData.SetColour(poptions==1);
	poptions=db->GetIValue("reportTriggers","printDuplex",recordId);
	pData.SetDuplex(poptions==0?wxDUPLEX_SIMPLEX:poptions==1?wxDUPLEX_HORIZONTAL:wxDUPLEX_VERTICAL);
	poptions=db->GetIValue("reportTriggers","printCollate",recordId);
	pData.SetCollate(poptions==1);
	pquality=db->GetIValue("reportTriggers","printQuality",(double)recordId);
	pData.SetQuality(pquality);

	if (!pData.Ok())
	{ pData=printData->GetPrintData(); }
	printData->SetPrintData(pData);
printWin=new wxPrintDialog(this,printData);
//printWin=new wxPageSetupDialog(this,&printData);

/*
if (!printWin->Ok())
{
	printWin->Destroy();
	pData.SetPrinterName("");
	printData->SetPrintData(pData);
	printWin=new wxPrintDialog(this,printData);
}
*/
if (printWin->ShowModal()==wxID_OK)
{
//	printData=printWin->GetPrintDialogData();
	*printData=printWin->GetPrintDialogData();
//	printData->SetMarginTopLeft(wxPoint(0,0));
//	printData->SetMarginBottomRight(wxPoint(0,0));
	pData=printData->GetPrintData();
	printerName.Printf("'%s'",pData.GetPrinterName());
	db->SetValue("reportTriggers","printer",recordId,printerName.c_str());

	db->SetValue("reportTriggers","paperOptions",recordId,(RECORD_ID)pData.GetOrientation());
	db->SetValue("reportTriggers","printQuality",recordId,(double)pData.GetQuality());
	db->SetValue("reportTriggers","printColor",recordId,(double)pData.GetColour());
	db->SetValue("reportTriggers","printDuplex",recordId,(double)(pData.GetDuplex()==wxDUPLEX_SIMPLEX?0:pData.GetDuplex()==wxDUPLEX_HORIZONTAL?1:2));
	db->SetValue("reportTriggers","printCollate",recordId,(double)pData.GetCollate());
	db->SetValue("reportTriggers","papersize",recordId,(RECORD_ID)pData.GetPaperId());
}
safe_delete(printData);
printWin->Destroy();
}

void brTriggerEditor::OnBrowse(wxCommandEvent &event)
{

}
